<?php
/**
 * Plugin Name: Zorro Analytics
 * Plugin URI: https://zorro.ewan.net
 * Description: Add Zorro Analytics tracking code to your WordPress site
 * Version: 1.0.0
 * Author: Zorro Analytics
 * License: GPL v2 or later
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Add menu item to WordPress admin
add_action('admin_menu', 'zorro_analytics_menu');

function zorro_analytics_menu() {
    add_options_page(
        'Zorro Analytics Settings',
        'Zorro Analytics',
        'manage_options',
        'zorro-analytics',
        'zorro_analytics_settings_page'
    );
}

// Register settings
add_action('admin_init', 'zorro_analytics_settings_init');

function zorro_analytics_settings_init() {
    register_setting('zorro_analytics_settings', 'zorro_analytics_site_id');
    
    add_settings_section(
        'zorro_analytics_section',
        'Zorro Analytics Configuration',
        'zorro_analytics_section_callback',
        'zorro_analytics_settings'
    );
    
    add_settings_field(
        'zorro_analytics_site_id',
        'Site ID',
        'zorro_analytics_site_id_render',
        'zorro_analytics_settings',
        'zorro_analytics_section'
    );
}

function zorro_analytics_section_callback() {
    echo '<p>Enter your Zorro Analytics Site ID below. You can find this in your Zorro Analytics dashboard.</p>';
}

function zorro_analytics_site_id_render() {
    $site_id = get_option('zorro_analytics_site_id', '');
    ?>
    <input type="text" name="zorro_analytics_site_id" value="<?php echo esc_attr($site_id); ?>" placeholder="ZA-XXXXXXXX" style="width: 300px;" />
    <p class="description">Example: ZA-INTUQWGI</p>
    <?php
}

// Settings page HTML
function zorro_analytics_settings_page() {
    if (!current_user_can('manage_options')) {
        return;
    }
    
    if (isset($_GET['settings-updated'])) {
        add_settings_error('zorro_analytics_messages', 'zorro_analytics_message', 'Settings saved successfully!', 'updated');
    }
    
    settings_errors('zorro_analytics_messages');
    ?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields('zorro_analytics_settings');
            do_settings_sections('zorro_analytics_settings');
            submit_button('Save Settings');
            ?>
        </form>
        
        <?php if (get_option('zorro_analytics_site_id')): ?>
        <div style="margin-top: 30px; padding: 15px; background: #f0f8ff; border-left: 4px solid #0073aa;">
            <h3>Tracking Status</h3>
            <p style="color: green;">✓ Zorro Analytics tracking code is active on your site.</p>
            <p>The tracking code will be automatically added to all pages.</p>
        </div>
        <?php endif; ?>
    </div>
    <?php
}

// Add tracking code to frontend
add_action('wp_footer', 'zorro_analytics_tracking_code', 100);

function zorro_analytics_tracking_code() {
    $site_id = get_option('zorro_analytics_site_id', '');
    
    // Only add tracking code if site ID is configured
    if (empty($site_id)) {
        return;
    }
    
    // Don't track logged-in administrators
    if (current_user_can('manage_options')) {
        echo "<!-- Zorro Analytics: Tracking disabled for administrators -->\n";
        return;
    }
    
    ?>
<!-- Zorro Analytics Tracking Code -->
<script src="https://zorro.ewan.net/tracking/zorro-analytics.js"></script>
<script>
    ZorroAnalytics.init('<?php echo esc_js($site_id); ?>', {
        endpoint: 'https://zorro.ewan.net/zorro-track.php'
    });
</script>
<!-- End Zorro Analytics Tracking Code -->
    <?php
}

// Add activation hook
register_activation_hook(__FILE__, 'zorro_analytics_activate');

function zorro_analytics_activate() {
    // Create default options if they don't exist
    add_option('zorro_analytics_site_id', '');
}

// Add deactivation hook
register_deactivation_hook(__FILE__, 'zorro_analytics_deactivate');

function zorro_analytics_deactivate() {
    // Clean up if needed (keeping settings for now in case of reactivation)
}